"""Tests and results

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


class TestError(Exception): pass

class InternalError(TestError): pass

class ConfigError(TestError): pass

class StopTest(TestError): pass


class SignalError(TestError): pass

class SignalPartialError(SignalError): pass

class SignalFailure(SignalError): pass


class Test:
   onError = None
   error_str = None
   onPartialError = None
   partial_error_str = None
   onSuccess = None
   success_str = None

   def __init__(self, **kw):
      for key, value in kw.items():
         if not hasattr(self, key):
            raise InternalError, (key, value)
         setattr(self, key, value)
      self.result = None # the test has not been run yet


   def run(self):
      try:
         self._run()
         self._success()
      except SignalFailure, details:
         self._failure(details)
      except SignalPartialError, details:
         self._partialerror(details)
      except SignalError, details:
         self._error(details)
      except:
         self._exception()


   def _run(self):
      raise NotImplementedError # this is abstract class

   def _success(self):
      if self.onSuccess == "ignore":
         return
      self.result = SuccessResult(self.success_str)

   def _failure(self, details):
      self.result = FailureResult(self.error_str, details)
      if self.onError == "abort":
         raise StopTest

   def _error(self, details):
      self.result = ErrorResult(self.error_str, details)
      if self.onError == "abort":
         raise StopTest

   def _partialerror(self, details):
      self.result = PartialErrorResult(self.partial_error_str, details)

   def _exception(self):
      self.result = ExceptionResult(self.error_str)


class TestResult:
   def __init__(self, title):
      self.title = title

   def __repr__(self):
      return "%s(%s)" % (self.__class__, self.title)

   def __str__(self):
      raise NotImplementedError # this is abstract class

class SuccessResult(TestResult):
   def __str__(self):
      return str(self.title)

class _ErrorResult(TestResult):
   def __init__(self, title, details):
      if title is None:
         if details:
            title = str(details)
         else:
            title = "Unknown error"
      TestResult.__init__(self, title)
      self.details = details

class FailureResult(_ErrorResult):
   def __str__(self):
      from templates.html import failure
      return failure(self.title, self.details)

class ErrorResult(_ErrorResult):
   def __str__(self):
      from templates.html import error
      return error(self.title, self.details)

class PartialErrorResult(_ErrorResult):
   def __str__(self):
      from templates.html import partial_error
      return partial_error(self.title, self.details)

class ExceptionResult(TestResult):
   def __init__(self, title):
      TestResult.__init__(self, title)

      import sys, traceback
      etype, value, tb = sys.exc_info()
      traceback.print_exception(etype, value, tb) # to stderr

      tb = ''.join(traceback.format_tb(tb))
      e = traceback.format_exception_only(etype, value)[0]

      from templates.html import exception
      self.result = exception(self.title, tb, e)
      etype = value = tb = None

   def __str__(self):
      return str(self.result)
