"""Asyncronous tests

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


import asyncore
from tests import Test, SignalError

class AsyncTest(Test):
   timeout = None # I want to get timeout from **kw in Test.__init__

   def __init__(self, **kw):
      Test.__init__(self, **kw)
      self.timeout = int(self.timeout)

   def _run(self):
      from time import time
      start_time = time()

      while asyncore.socket_map:
         asyncore.poll(5)
         if time() - start_time > self.timeout:
            asyncore.close_all()
            raise SignalError, "timeout"
