#! /usr/bin/env python
"""Syncronous email tests

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


import socket
socket.setdefaulttimeout(30) # default timeout in seconds
from tests import SignalFailure


def test_smtp(server_name, user):
   from smtplib import SMTP
   server = SMTP(server_name)
   server.sendmail(user, user,
"""From: %s
To: %s
Subject: test mail %s
Precedence: bulk

Test.
""" % (user, user, server_name))
   server.quit()


def test_pop3(server_name, user, passwd):
   import poplib
   server = poplib.POP3(server_name)

   server.user(user)
   server.pass_(passwd)

   messages = []
   try:
      for resp in server.list():
         if resp and isinstance(resp, list):
            msg_no = resp[0].split()[0]
            messages.append(msg_no)

      if not messages:
         raise SignalFailure, "no messages on the POP3 server"

      for msg_no in messages:
         server.dele(msg_no)

   finally:
      server.quit()


if __name__ == "__main__":
   test_user = "test-iskra@iskra.aviel.ru"

   print "Sending...",
   test_smtp("mail", test_user)
   print "ok"

   from time import sleep
   sleep(10)

   import getpass
   passwd = getpass.getpass("Password: ")

   print "Receiving...",
   test_pop3("mail", test_user, passwd)
   print "ok"
