#! /usr/bin/env python
"""Asyncronous HTTP tests

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


import sys
import asyncore, socket
from tests import SignalError, SignalPartialError


class http_client(asyncore.dispatcher_with_send):
   def __init__(self, host, port=None, uri='/'):
      asyncore.dispatcher_with_send.__init__(self)
      self.create_socket(socket.AF_INET, socket.SOCK_STREAM)

      if not port and (host.find(':') == host.rfind(':')):
         i = host.rfind(':')
         if i >= 0:
            host, port = host[:i], host[i+1:]
            try:
               port = int(port)
            except ValueError:
               raise socket.error, "nonnumeric port `%s'" % port
      if not port:
         from httplib import HTTP_PORT
         port = HTTP_PORT

      self.host = host
      self.port = port
      self.uri = uri
      self.http_status = None
      self.connect((host, port))

   def handle_connect(self):
      self.connected = 1
      request = self.build_request()
      self.send("\r\n".join(request) + "\r\n\r\n")

   def build_request(self):
      return ["GET %s HTTP/1.0" % self.uri]

   def handle_read(self):
      test_http_status = self.http_status is None
      try:
         data = self.recv(8192)
         if test_http_status:
            self.http_status = http_status = \
               int(data.split('\n')[0].split()[1])
      except: # It seems headers have been cut on code "200 Ok"
          pass
      else:
         if test_http_status and http_status <> 200:
            raise SignalPartialError('Error %d' % http_status)

   def handle_close(self):
      self.close()

   def handle_error(self):
      exc, self.exc_value, tb = sys.exc_info()
      if exc is not SignalPartialError:
         exc = SignalError
      self.exc = exc
      del tb # Break reference loop
      self.close()

class www_client(http_client):
   def build_request(self):
      request = http_client.build_request(self)
      request.extend(["Host: %s:%d" % (self.host, self.port), "Connection: close"])
      return request


from time import time

def test_www():
   try:
      www_client("localhost")
   except socket.error:
      print "Cannot connect"
      return

   start_time = time()
   while asyncore.socket_map:
      asyncore.poll(5)
      if time() - start_time > 30:
         asyncore.close_all()
         print "WWW timeout!"

def test_proxy():
   try:
      http_client("localhost:3128", uri="http://localhost/")
   except socket.error:
      print "Cannot connect"
      return

   start_time = time()
   while asyncore.socket_map:
      asyncore.poll(5)
      if time() - start_time > 30:
         asyncore.close_all()
         print "Proxy timeout!"

if __name__ == "__main__":
   test_www()
   test_proxy()
