"""Test DNS resolver(s)

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


from tests import SignalPartialError
from tests.async import AsyncTest

class TestDNS(AsyncTest):
   def __init__(self, **kw):
      resolvers_num = int(kw["resolvers"])
      del kw["resolvers"]
      resolvers = []
      for i in range(1, resolvers_num+1):
         resolver = kw["resolver%d" % i]
         del kw["resolver%d" % i]
         names_num = int(kw["names%d" % i])
         del kw["names%d" % i]
         names = []
         for j in range(1, names_num+1):
            name = kw["resolve%d_name%d" % (i, j)]
            del kw["resolve%d_name%d" % (i, j)]
            addr = kw["resolve%d_addr%d" % (i, j)]
            del kw["resolve%d_addr%d" % (i, j)]
            names.append((name, addr, []))
         resolvers.append((resolver, names, []))
      self.resolvers = resolvers
      AsyncTest.__init__(self, **kw)


   def _callback(self, host, ttl, answer):
      for resolver, names, rlist in self.resolvers:
         all_checked = True
         for name, addr, checked in names:
            if name == host:
               if addr == answer:
                  if checked: raise SignalPartialError, "Duplicate answer for host `%s': `%s'" % (host, answer)
                  else: checked.append(1)
               else: raise SignalPartialError, "Unexpected answer for host `%s': expected `%s', got `%s'" % (host, addr, answer)
            if not checked: all_checked = False
         if all_checked:
            for r in rlist: r.close()


   def _run(self):
      for host, names, rlist in self.resolvers:
         r = Resolver(host)
         rlist.append(r)
         for name, addr, checked in names:
            r.resolve(name, self._callback)
      AsyncTest._run(self)


from medusa.resolver import resolver
class Resolver(resolver):
   def handle_connect(self):
      pass # just ignore it to stop asyncore from complaining "unhandled connect event"
