"""Test SMTP and POP3 server(s)

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


import socket
from tests import Test, SignalError
from tests.e_mail import test_smtp, test_pop3

class TestSMTP(Test):
   server = None
   user = None
   timeout = 10
   pause_after = None

   def __init__(self, **kw):
      Test.__init__(self, **kw)
      self.timeout = int(self.timeout)
      if self.pause_after:
         self.pause_after = int(self.pause_after)

   def _run(self):
      socket.setdefaulttimeout(self.timeout)
      try:
         test_smtp(self.server, self.user)
      except Exception, msg:
         raise SignalError, msg
      if self.pause_after:
         from time import sleep
         sleep(self.pause_after)


class TestPOP3(Test):
   server = None
   user = None
   password = None
   timeout = 10

   def __init__(self, **kw):
      Test.__init__(self, **kw)
      self.timeout = int(self.timeout)

   def _run(self):
      socket.setdefaulttimeout(self.timeout)
      try:
         test_pop3(self.server, self.user, self.password)
      except Exception, msg:
         raise SignalError, msg
