"""Test WWW server(s) and proxie(s)

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


from tests.async import AsyncTest
from tests.http import http_client, www_client


class TestWWW(AsyncTest):
   def __init__(self, **kw):
      hosts_num = int(kw["www_servers"])
      del kw["www_servers"]

      servers = []
      for i in range(1, hosts_num+1):
         servers.append(kw["www_server%d" % i])
         del kw["www_server%d" % i]
      self.servers = servers

      AsyncTest.__init__(self, **kw)

   def _run(self):
      clients = []
      for server in self.servers:
         clients.append(www_client(server))

      AsyncTest._run(self)

      for client in clients:
         if hasattr(client, 'exc') and hasattr(client, 'exc_value'):
            if self.partial_error_str:
               try:
                  self.partial_error_str = self.partial_error_str % client.host
               except TypeError: # the string does not contain %s
                  pass
            raise client.exc(client.exc_value)


class TestHTTPProxy(AsyncTest):
   def __init__(self, **kw):
      proxies_num = int(kw["proxies"])
      del kw["proxies"]

      proxies = []
      for i in range(1, proxies_num+1):
         proxy = kw["proxy%d" % i]
         del kw["proxy%d" % i]
         urls = []
         urls_num = int(kw["proxy%d_urls" % i])
         del kw["proxy%d_urls" % i]
         for j in range(1, urls_num+1):
            urls.append(kw["proxy%d_url%d" % (i, j)])
            del kw["proxy%d_url%d" % (i, j)]
         proxies.append((proxy, urls))
      self.proxies = proxies

      AsyncTest.__init__(self, **kw)

   def _run(self):
      for proxy, urls in self.proxies:
         for url in urls:
            http_client(proxy, uri=url)
      AsyncTest._run(self)
