"""Test ping(s)

This module is a part of Uptime package.

"""

__author__ = "Oleg Broytman <phd@phdru.name>"
__copyright__ = "Copyright (C) 2003-2013 PhiloSoft Design"
__license__ = "GNU GPL"


import sys, os
home_dir = os.path.dirname(os.path.abspath(sys.argv[0]))

from tests import Test, SignalError, SignalPartialError, SignalFailure

class TestPing(Test):
   IP = None # I want to get IP from **kw in Test.__init__

   def __init__(self, **kw):
      Test.__init__(self, **kw)
      if self.error_str:
         try:
            self.error_str = self.error_str % self.IP
         except TypeError: # the string does not contain %s
            pass

      if self.partial_error_str:
         try:
            self.partial_error_str = self.partial_error_str % self.IP
         except TypeError: # the string does not contain %s
            pass

      if self.success_str:
         try:
            self.success_str = self.success_str % self.IP
         except TypeError: # the string does not contain %s
            pass


   def _run(self):
      "Ping the given IP using helper and parse the result code"
      result = os.system(os.path.join(home_dir, "bin", "isalive") + " '%s'" % self.IP) # I am not going to meddle with raw IP :-)
      if os.WIFSIGNALED(result):
         signal = os.WSTOPSIG(result)
         raise SignalFailure, "Test failed with signal `%s'" % signal
      else:
         exit_status = os.WEXITSTATUS(result)
         if exit_status == 5:
            return # success
         if 0 < exit_status < 5:
            raise SignalPartialError, "Only %s echo replies out of 5" % exit_status
         if exit_status == 0:
            raise SignalError, "No echo replies"
         raise SignalFailure, "Unknown exit code `%s'" % exit_status
